import * as yup from 'yup';
import type { SendMail } from '~/interface/send_mail.interface';
import { emailClient, emailSeller } from '~/utils/utils';

const schema = yup.object().shape({
  name: yup.string().required('name is required'),
  phone_number: yup.string().required('phone number is required'),
  email: yup.string().required('email is required'),
  message: yup.string().required('message is required'),
})

export default defineEventHandler(async (event) => {
  try {
    const body = await readBody(event) as SendMail;

    await schema.validate(body);

    const { sendMail } = useNodeMailer();

    await sendMail({ 
      to: body.email,
      subject: 'Contacto', 
      html: emailClient(body),
    });
      
    const runtimeConfig = useRuntimeConfig();
    const email_default = `contacto@leviathanlimpiezaoceanica.com.mx`;

    await sendMail({
      to: email_default,
      cc: runtimeConfig.public.email,
      subject: 'Nuevo prospecto', 
      html: emailSeller(body),
    });

    return true;


  } catch (error: any) {
    console.error(error);
    return false;
  }

})