// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  compatibilityDate: '2024-04-03',
  devtools: { enabled: true },
  app: {
    head: {
      title: 'Leviathán',
      htmlAttrs: {
        lang: 'es'
      },
      meta: [
        { charset: 'utf-8' },
        { name: 'viewport', content: 'width=device-width, initial-scale=1' }
      ],
      link: [
        { rel: "icon", type: "image/x-icon", href: "/favicon.ico" }
      ],
      script: [
        { src: "https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" },
        { src: 'https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js'},
      ]
    },
  },
  runtimeConfig: {
    public: {
      facebook: 'https://www.facebook.com/people/Leviath%C3%A1n/61551906645064',
      instagram: 'https://www.instagram.com/leviatanlimpiezaoceanica',
      phone_whatsapp: '529982013737',
      email: 'leviathansoluciones@gmail.com',
      phones: [
        {
          label: '+52 (998)-201-3737',
          number: '+529982013737',
        },
        {
          label: '+52 (998)-423-6872',
          number: '+529984236872',
        },
        {
          label: '+52 (998)-616-0318',
          number: '+529986160318',
        },
      ]
    }
  },
  modules: [
    '@pinia/nuxt', 
    "nuxt-easy-lightbox",
    "nuxt-nodemailer",
  ],
  nodemailer: {
    from: '"Leviathán soluciones" <contacto@leviathanlimpiezaoceanica.com.mx>',
    host: 'leviathanlimpiezaoceanica.com.mx',
    port: 465,
    secure: true,
    auth: {
      user: 'contacto@leviathanlimpiezaoceanica.com.mx',
      pass: 'bs4u6VQ8RJ',
    }
  },
  plugins: [
  ],
  css: [
    '@/assets/css/bootstrap.css',
    'bootstrap-icons/font/bootstrap-icons.css',
  ],
  
  components: [
    { path: '~/components/shared', prefix: 'Shared' },
    { path: '~/components/about', prefix: 'About' },
    { path: '~/components/services', prefix: 'Services' },
    { path: '~/components/contact', prefix: 'Contact' },
    '~/components'
  ],
  build: {
    transpile: ['bootstrap']
  },
  devServer: {
    port: 40000,
  },
})